/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chemistry.utils;

import edu.colorado.phet.chemistry.model.Element;

public class ChemUtils {
    public static String createSymbol(Element[] elementArray) {
        return ChemUtils.toSubscript(ChemUtils.createSymbolWithoutSubscripts(elementArray));
    }

    public static String createSymbolWithoutSubscripts(Element[] elementArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        for (int i = 0; i < elementArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append(elementArray[i].getSymbol());
                continue;
            }
            if (elementArray[i].equals(elementArray[i - 1])) {
                ++n;
                continue;
            }
            if (n > 1) {
                stringBuffer.append(String.valueOf(n));
            }
            n = 1;
            stringBuffer.append(elementArray[i].getSymbol());
        }
        if (n > 1) {
            stringBuffer.append(String.valueOf(n));
        }
        return stringBuffer.toString();
    }

    public static String toSubscript(String string) {
        String string2 = "";
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl && Character.isDigit(c)) {
                string2 = string2 + "<sub>";
                bl = true;
            } else if (bl && !Character.isDigit(c)) {
                string2 = string2 + "</sub>";
                bl = false;
            }
            string2 = string2 + c;
        }
        if (bl) {
            string2 = string2 + "</sub>";
            bl = false;
        }
        return string2;
    }
}

