/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.view;

import edu.colorado.phet.balancingchemicalequations.BCEStrings;
import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.model.EquationTerm;
import edu.colorado.phet.balancingchemicalequations.view.HorizontalAligner;
import edu.colorado.phet.balancingchemicalequations.view.RightArrowNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxesNode
extends PComposite {
    private final IntegerRange coefficientRange;
    private final HorizontalAligner aligner;
    private final PComposite moleculesParentNode;
    private final SimpleObserver coefficientsObserver;
    private final RightArrowNode arrowNode;
    private final HTMLNode moleculesHiddenLeftNode;
    private final HTMLNode moleculesHiddenRightNode;
    private Equation equation;
    private boolean balancedHighlightEnabled;

    public BoxesNode(final Property<Equation> property, IntegerRange integerRange, HorizontalAligner horizontalAligner, final Property<Color> property2, final Property<Boolean> property3) {
        this.coefficientRange = integerRange;
        this.aligner = horizontalAligner;
        this.balancedHighlightEnabled = true;
        final BoxNode boxNode = new BoxNode(horizontalAligner.getBoxSizeReference());
        this.addChild(boxNode);
        final BoxNode boxNode2 = new BoxNode(horizontalAligner.getBoxSizeReference());
        this.addChild(boxNode2);
        this.arrowNode = new RightArrowNode(property.get().isBalanced());
        this.addChild(this.arrowNode);
        this.moleculesParentNode = new PComposite();
        this.addChild(this.moleculesParentNode);
        this.moleculesHiddenLeftNode = new MoleculesAreHiddenNode();
        this.addChild(this.moleculesHiddenLeftNode);
        this.moleculesHiddenRightNode = new MoleculesAreHiddenNode();
        this.addChild(this.moleculesHiddenRightNode);
        double d = 0.0;
        double d2 = 0.0;
        boxNode.setOffset(d, d2);
        this.moleculesParentNode.setOffset(d, d2);
        d = horizontalAligner.getCenterXOffset() - this.arrowNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = boxNode.getFullBoundsReference().getCenterY() - this.arrowNode.getFullBoundsReference().getHeight() / 2.0;
        this.arrowNode.setOffset(d, d2);
        d = boxNode.getFullBoundsReference().getMaxX() + horizontalAligner.getBoxSeparation();
        d2 = boxNode.getYOffset();
        boxNode2.setOffset(d, d2);
        d = boxNode.getFullBoundsReference().getCenterX() - this.moleculesHiddenLeftNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = boxNode.getFullBoundsReference().getCenterY() - this.moleculesHiddenLeftNode.getFullBoundsReference().getHeight() / 2.0;
        this.moleculesHiddenLeftNode.setOffset(d, d2);
        d = boxNode2.getFullBoundsReference().getCenterX() - this.moleculesHiddenRightNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = boxNode2.getFullBoundsReference().getCenterY() - this.moleculesHiddenRightNode.getFullBoundsReference().getHeight() / 2.0;
        this.moleculesHiddenRightNode.setOffset(d, d2);
        this.coefficientsObserver = new SimpleObserver(){

            public void update() {
                BoxesNode.this.updateNode();
            }
        };
        this.equation = property.get();
        property.addObserver(new SimpleObserver(){

            public void update() {
                BoxesNode.this.equation.removeCoefficientsObserver(BoxesNode.this.coefficientsObserver);
                BoxesNode.this.equation = (Equation)property.get();
                BoxesNode.this.equation.addCoefficientsObserver(BoxesNode.this.coefficientsObserver);
            }
        });
        property2.addObserver(new SimpleObserver(){

            public void update() {
                boxNode.setPaint((Paint)property2.get());
                boxNode2.setPaint((Paint)property2.get());
            }
        });
        property3.addObserver(new SimpleObserver(){

            public void update() {
                BoxesNode.this.setMoleculesVisible((Boolean)property3.get());
            }
        });
    }

    private void setMoleculesVisible(boolean bl) {
        this.moleculesParentNode.setVisible(bl);
        this.moleculesHiddenLeftNode.setVisible(!bl);
        this.moleculesHiddenRightNode.setVisible(!bl);
    }

    public void setBalancedHighlightEnabled(boolean bl) {
        if (bl != this.balancedHighlightEnabled) {
            this.balancedHighlightEnabled = bl;
            this.arrowNode.setHighlighted(this.equation.isBalanced() && this.balancedHighlightEnabled);
        }
    }

    private void updateNode() {
        this.moleculesParentNode.removeAllChildren();
        this.createMolecules(this.equation.getReactants(), this.aligner.getReactantXOffsets(this.equation));
        this.createMolecules(this.equation.getProducts(), this.aligner.getProductXOffsets(this.equation));
        this.arrowNode.setHighlighted(this.equation.isBalanced() && this.balancedHighlightEnabled);
    }

    private void createMolecules(EquationTerm[] equationTermArray, double[] dArray) {
        assert (equationTermArray.length == dArray.length);
        double d = (this.aligner.getBoxSizeReference().getHeight() - 20.0) / (double)this.coefficientRange.getMax();
        for (int i = 0; i < equationTermArray.length; ++i) {
            int n = equationTermArray[i].getUserCoefficient();
            Image image = equationTermArray[i].getMolecule().getImage();
            double d2 = 0.0;
            d2 = 10.0 + d / 2.0;
            for (int j = 0; j < n; ++j) {
                PImage pImage = new PImage(image);
                this.moleculesParentNode.addChild(pImage);
                pImage.setOffset(dArray[i] - pImage.getFullBoundsReference().getWidth() / 2.0, d2 - pImage.getFullBoundsReference().getHeight() / 2.0);
                d2 += d;
            }
        }
    }

    private static class BoxNode
    extends PPath {
        public BoxNode(Dimension dimension) {
            super(new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight()));
            this.setStrokePaint(Color.BLACK);
            this.setStroke(new BasicStroke(1.0f));
        }
    }

    private static class MoleculesAreHiddenNode
    extends HTMLNode {
        public MoleculesAreHiddenNode() {
            super(BCEStrings.MOLECULES_ARE_HIDDEN, Color.WHITE, new PhetFont(18));
        }
    }
}

