/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.view;

import edu.colorado.phet.balancingchemicalequations.BCEConstants;
import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.chemistry.molecules.AtomNode;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class BalanceScaleNode
extends PComposite {
    private static final PDimension FULCRUM_SIZE = new PDimension(60.0, 45.0);
    private final Element element;
    private int leftNumberOfAtoms;
    private int rightNumberOfAtoms;
    private final BeamNode beamNode;
    private final PNode atomPilesParentNode;

    public BalanceScaleNode(Element element, int n, int n2, boolean bl) {
        this.element = element;
        this.leftNumberOfAtoms = n;
        this.rightNumberOfAtoms = n2;
        FulcrumNode fulcrumNode = new FulcrumNode(element);
        this.addChild(fulcrumNode);
        this.beamNode = new BeamNode();
        this.addChild(this.beamNode);
        this.atomPilesParentNode = new PComposite();
        this.addChild(this.atomPilesParentNode);
        this.setHighlighted(bl);
        this.updateNode();
    }

    public void setHighlighted(boolean bl) {
        this.beamNode.setHighlighted(bl);
    }

    public static double getBeamLength() {
        return 315.0;
    }

    private void updateNode() {
        this.atomPilesParentNode.removeAllChildren();
        PNode pNode = BalanceScaleNode.createAtomPile(this.leftNumberOfAtoms, this.element);
        pNode.setOffset(-78.75 - pNode.getFullBoundsReference().getWidth() / 2.0, 0.0);
        this.atomPilesParentNode.addChild(pNode);
        PNode pNode2 = BalanceScaleNode.createAtomPile(this.rightNumberOfAtoms, this.element);
        pNode2.setOffset(78.75 - pNode2.getFullBoundsReference().getWidth() / 2.0, 0.0);
        this.atomPilesParentNode.addChild(pNode2);
        CountNode countNode = new CountNode(this.leftNumberOfAtoms);
        this.atomPilesParentNode.addChild(countNode);
        double d = pNode.getXOffset() + pNode.getFullBoundsReference().getWidth() / 2.0 - countNode.getFullBoundsReference().getWidth() / 2.0;
        double d2 = pNode.getFullBoundsReference().getMinY() - countNode.getFullBoundsReference().getHeight() - 2.0;
        countNode.setOffset(d, d2);
        CountNode countNode2 = new CountNode(this.rightNumberOfAtoms);
        this.atomPilesParentNode.addChild(countNode2);
        d = pNode2.getXOffset() + pNode2.getFullBoundsReference().getWidth() / 2.0 - countNode2.getFullBoundsReference().getWidth() / 2.0;
        d2 = pNode2.getFullBoundsReference().getMinY() - countNode2.getFullBoundsReference().getHeight() - 2.0;
        countNode2.setOffset(d, d2);
        double d3 = 1.5707963267948966 - Math.acos(FULCRUM_SIZE.getHeight() / 157.5);
        double d4 = this.rightNumberOfAtoms - this.leftNumberOfAtoms;
        double d5 = 0.0;
        if (Math.abs(d4) >= 6.0) {
            int n = (int)(Math.abs(d4) / d4);
            d5 = (double)n * d3;
        } else {
            d5 = d4 * (d3 / 6.0);
        }
        this.beamNode.setRotation(d5);
        this.atomPilesParentNode.setRotation(d5);
    }

    private static PNode createAtomPile(int n, Element element) {
        PComposite pComposite = new PComposite();
        int n2 = 5;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            AtomNode atomNode = new AtomNode(element);
            pComposite.addChild(atomNode);
            ((PNode)atomNode).setOffset(d + atomNode.getFullBoundsReference().getWidth() / 2.0, d2 - atomNode.getFullBoundsReference().getHeight() / 2.0);
            if (--n2 > 0) {
                d = atomNode.getFullBoundsReference().getMaxX();
                continue;
            }
            if (n3 < 4) {
                n2 = 5 - ++n3;
                d = (double)(n4 + n3) * (atomNode.getFullBoundsReference().getWidth() / 2.0);
                d2 = -((double)n3 * 0.85 * atomNode.getFullBoundsReference().getHeight());
                continue;
            }
            n3 = 0;
            n2 = 5;
            d = (double)(++n4) * (atomNode.getFullBoundsReference().getWidth() / 2.0);
            d2 = 0.0;
        }
        return pComposite;
    }

    private static class BeamNode
    extends PPath {
        public BeamNode() {
            Rectangle2D.Double double_ = new Rectangle2D.Double(-157.5, -3.0, 315.0, 6.0);
            this.setPathTo(double_);
            this.setStrokePaint(Color.BLACK);
        }

        public void setHighlighted(boolean bl) {
            this.setPaint(bl ? BCEConstants.BALANCED_HIGHLIGHT_COLOR : Color.BLACK);
            this.setStroke(bl ? new BasicStroke(1.0f) : null);
        }
    }

    private static class CountNode
    extends PText {
        public CountNode(int n) {
            this.setText(String.valueOf(n));
            this.setFont(new PhetFont(18));
            this.setTextPaint(Color.BLACK);
        }
    }

    private static class FulcrumNode
    extends PComposite {
        private static final Paint FILL_PAINT = new GradientPaint(new Point2D.Double(0.0, 0.0), Color.WHITE, new Point2D.Double(0.0, BalanceScaleNode.access$000().getHeight()), Color.LIGHT_GRAY);

        public FulcrumNode(Element element) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo((float)(FULCRUM_SIZE.getWidth() / 2.0), (float)FULCRUM_SIZE.getHeight());
            generalPath.lineTo((float)(-FULCRUM_SIZE.getWidth() / 2.0), (float)FULCRUM_SIZE.getHeight());
            generalPath.closePath();
            PPath pPath = new PPath(generalPath);
            pPath.setPaint(FILL_PAINT);
            pPath.setStroke(new BasicStroke(1.0f));
            pPath.setStrokePaint(Color.BLACK);
            this.addChild(pPath);
            PText pText = new PText(element.getSymbol());
            pText.setFont(new PhetFont(22));
            pText.setTextPaint(Color.BLACK);
            this.addChild(pText);
            double d = 0.0;
            double d2 = 0.0;
            pPath.setOffset(d, d2);
            d = -pText.getFullBoundsReference().getWidth() / 2.0;
            d2 = pPath.getFullBoundsReference().getMaxY() - pText.getFullBoundsReference().getHeight() - 2.0;
            pText.setOffset(d, d2);
        }
    }
}

