/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.module.introduction;

import edu.colorado.phet.balancingchemicalequations.BCEGlobalProperties;
import edu.colorado.phet.balancingchemicalequations.control.BalancedRepresentationChoiceNode;
import edu.colorado.phet.balancingchemicalequations.control.EquationChoiceNode;
import edu.colorado.phet.balancingchemicalequations.module.introduction.IntroductionModel;
import edu.colorado.phet.balancingchemicalequations.view.BCECanvas;
import edu.colorado.phet.balancingchemicalequations.view.BalanceScalesNode;
import edu.colorado.phet.balancingchemicalequations.view.BalancedRepresentation;
import edu.colorado.phet.balancingchemicalequations.view.BarChartsNode;
import edu.colorado.phet.balancingchemicalequations.view.BoxesNode;
import edu.colorado.phet.balancingchemicalequations.view.DevAnswerNode;
import edu.colorado.phet.balancingchemicalequations.view.EquationNode;
import edu.colorado.phet.balancingchemicalequations.view.HorizontalAligner;
import edu.colorado.phet.balancingchemicalequations.view.IntroductionFaceNode;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;

class IntroductionCanvas
extends BCECanvas {
    private static final Dimension BOX_SIZE = new Dimension(475, 220);
    private final Property<BalancedRepresentation> balanceChoiceProperty;
    private final BoxesNode boxesNode;

    public IntroductionCanvas(IntroductionModel introductionModel, final BCEGlobalProperties bCEGlobalProperties, Resettable resettable) {
        super(bCEGlobalProperties.canvasColor);
        HorizontalAligner horizontalAligner = new HorizontalAligner(BOX_SIZE, 90.0);
        this.balanceChoiceProperty = new Property<BalancedRepresentation>(BalancedRepresentation.NONE);
        EquationChoiceNode equationChoiceNode = new EquationChoiceNode(introductionModel.getEquations(), introductionModel.currentEquation, bCEGlobalProperties.canvasColor);
        this.addChild(equationChoiceNode);
        EquationNode equationNode = new EquationNode(introductionModel.currentEquation, introductionModel.getCoefficientsRange(), horizontalAligner);
        this.addChild(equationNode);
        this.boxesNode = new BoxesNode(introductionModel.currentEquation, introductionModel.getCoefficientsRange(), horizontalAligner, bCEGlobalProperties.boxColor, bCEGlobalProperties.moleculesVisible);
        this.addChild(this.boxesNode);
        BalancedRepresentationChoiceNode balancedRepresentationChoiceNode = new BalancedRepresentationChoiceNode(this.balanceChoiceProperty, bCEGlobalProperties.canvasColor);
        this.addChild(balancedRepresentationChoiceNode);
        final BarChartsNode barChartsNode = new BarChartsNode(introductionModel.currentEquation, horizontalAligner);
        this.addChild(barChartsNode);
        final BalanceScalesNode balanceScalesNode = new BalanceScalesNode(introductionModel.currentEquation, horizontalAligner);
        this.addChild(balanceScalesNode);
        IntroductionFaceNode introductionFaceNode = new IntroductionFaceNode(introductionModel.currentEquation);
        this.addChild(introductionFaceNode);
        ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(resettable, (Component)bCEGlobalProperties.frame, 12, Color.BLACK, Color.WHITE);
        resetAllButtonNode.scale(1.5);
        this.addChild(resetAllButtonNode);
        final DevAnswerNode devAnswerNode = new DevAnswerNode(introductionModel.currentEquation);
        this.addChild(devAnswerNode);
        devAnswerNode.setVisible(bCEGlobalProperties.answersVisible.get());
        double d = 35.0;
        double d2 = this.boxesNode.getFullBoundsReference().getMaxX() - equationChoiceNode.getFullBoundsReference().getWidth();
        equationChoiceNode.setOffset(d2, 0.0);
        double d3 = equationChoiceNode.getFullBoundsReference().getMaxY() + d;
        equationNode.setOffset(0.0, d3);
        d3 = equationNode.getFullBoundsReference().getMaxY() + d;
        this.boxesNode.setOffset(0.0, d3);
        d2 = this.boxesNode.getFullBoundsReference().getCenterX() - introductionFaceNode.getFullBoundsReference().getWidth() / 2.0;
        d3 = this.boxesNode.getFullBoundsReference().getMaxY() + 15.0;
        introductionFaceNode.setOffset(d2, d3);
        d3 = this.boxesNode.getFullBoundsReference().getMaxY() + 180.0;
        barChartsNode.setOffset(0.0, d3);
        d3 = barChartsNode.getYOffset() - 10.0;
        balanceScalesNode.setOffset(0.0, d3);
        d3 = Math.max(barChartsNode.getFullBoundsReference().getMaxY(), balanceScalesNode.getFullBoundsReference().getMaxY()) + d;
        balancedRepresentationChoiceNode.setOffset(0.0, d3);
        d2 = this.boxesNode.getFullBoundsReference().getMaxX() - resetAllButtonNode.getFullBoundsReference().getWidth();
        d3 = balancedRepresentationChoiceNode.getFullBoundsReference().getMinY();
        resetAllButtonNode.setOffset(d2, d3);
        d2 = this.boxesNode.getFullBoundsReference().getMinX();
        d3 = this.boxesNode.getFullBoundsReference().getMaxY() + 4.0;
        devAnswerNode.setOffset(d2, d3);
        this.balanceChoiceProperty.addObserver(new SimpleObserver(){

            public void update() {
                barChartsNode.setVisible(((BalancedRepresentation)((Object)IntroductionCanvas.this.balanceChoiceProperty.get())).equals((Object)BalancedRepresentation.BAR_CHARTS));
                balanceScalesNode.setVisible(((BalancedRepresentation)((Object)IntroductionCanvas.this.balanceChoiceProperty.get())).equals((Object)BalancedRepresentation.BALANCE_SCALES));
            }
        });
        bCEGlobalProperties.answersVisible.addObserver(new SimpleObserver(){

            public void update() {
                devAnswerNode.setVisible(bCEGlobalProperties.answersVisible.get());
            }
        });
    }

    public void reset() {
        this.balanceChoiceProperty.reset();
    }
}

