/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.module.game;

import edu.colorado.phet.balancingchemicalequations.model.DecompositionEquation;
import edu.colorado.phet.balancingchemicalequations.model.DisplacementEquation;
import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.model.SynthesisEquation;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GameFactory {
    private static final EquationClassesList LEVEL1_POOL = new EquationClassesList(){
        {
            this.add(SynthesisEquation.Synthesis_2H2_O2_2H2O.class);
            this.add(SynthesisEquation.Synthesis_H2_F2_2HF.class);
            this.add(DecompositionEquation.Decomposition_2HCl_H2_Cl2.class);
            this.add(DecompositionEquation.Decomposition_CH3OH_CO_2H2.class);
            this.add(SynthesisEquation.Synthesis_CH2O_H2_CH3OH.class);
            this.add(DecompositionEquation.Decomposition_C2H6_C2H4_H2.class);
            this.add(SynthesisEquation.Synthesis_C2H2_2H2_C2H6.class);
            this.add(SynthesisEquation.Synthesis_C_O2_CO2.class);
            this.add(SynthesisEquation.Synthesis_2C_O2_2CO.class);
            this.add(DecompositionEquation.Decomposition_2CO2_2CO_O2.class);
            this.add(DecompositionEquation.Decomposition_2CO_C_CO2.class);
            this.add(SynthesisEquation.Synthesis_C_2S_CS2.class);
            this.add(DecompositionEquation.Decomposition_2NH3_N2_3H2.class);
            this.add(DecompositionEquation.Decomposition_2NO_N2_O2.class);
            this.add(DecompositionEquation.Decomposition_2NO2_2NO_O2.class);
            this.add(SynthesisEquation.Synthesis_2N2_O2_2N2O.class);
            this.add(SynthesisEquation.Synthesis_P4_6H2_4PH3.class);
            this.add(SynthesisEquation.Synthesis_P4_6F2_4PF3.class);
            this.add(DecompositionEquation.Decomposition_4PCl3_P4_6Cl2.class);
            this.add(DecompositionEquation.Decomposition_PCl5_PCl3_Cl2.class);
            this.add(DecompositionEquation.Decomposition_2SO3_2SO2_O2.class);
        }
    };
    private static final EquationClassesList LEVEL2_POOL = new EquationClassesList(){
        {
            this.add(DisplacementEquation.Displacement_2C_2H2O_CH4_CO2.class);
            this.add(DisplacementEquation.Displacement_CH4_H2O_3H2_CO.class);
            this.add(DisplacementEquation.Displacement_CH4_2O2_CO2_2H2O.class);
            this.add(DisplacementEquation.Displacement_C2H4_3O2_2CO2_2H2O.class);
            this.add(DisplacementEquation.Displacement_C2H6_Cl2_C2H5Cl_HCl.class);
            this.add(DisplacementEquation.Displacement_CH4_4S_CS2_2H2S.class);
            this.add(DisplacementEquation.Displacement_CS2_3O2_CO2_2SO2.class);
            this.add(DisplacementEquation.Displacement_SO2_2H2_S_2H2O.class);
            this.add(DisplacementEquation.Displacement_SO2_3H2_H2S_2H2O.class);
            this.add(DisplacementEquation.Displacement_2F2_H2O_OF2_2HF.class);
            this.add(DisplacementEquation.Displacement_OF2_H2O_O2_2HF.class);
        }
    };
    private static final EquationClassesList LEVEL3_POOL = new EquationClassesList(){
        {
            this.add(DisplacementEquation.Displacement_2C2H6_7O2_4CO2_6H2O.class);
            this.add(DisplacementEquation.Displacement_4CO2_6H2O_2C2H6_7O2.class);
            this.add(DisplacementEquation.Displacement_2C2H2_5O2_4CO2_2H2O.class);
            this.add(DisplacementEquation.Displacement_4CO2_2H2O_2C2H2_5O2.class);
            this.add(DisplacementEquation.Displacement_C2H5OH_3O2_2CO2_3H2O.class);
            this.add(DisplacementEquation.Displacement_2CO2_3H2O_C2H5OH_3O2.class);
            this.add(DisplacementEquation.Displacement_4NH3_3O2_2N2_6H2O.class);
            this.add(DisplacementEquation.Displacement_2N2_6H2O_4NH3_3O2.class);
            this.add(DisplacementEquation.Displacement_4NH3_5O2_4NO_6H2O.class);
            this.add(DisplacementEquation.Displacement_4NO_6H2O_4NH3_5O2.class);
            this.add(DisplacementEquation.Displacement_4NH3_7O2_4NO2_6H2O.class);
            this.add(DisplacementEquation.Displacement_4NO2_6H2O_4NH3_7O2.class);
            this.add(DisplacementEquation.Displacement_4NH3_6NO_5N2_6H2O.class);
            this.add(DisplacementEquation.Displacement_5N2_6H2O_4NH3_6NO.class);
        }
    };
    private static final ExclusionsMap LEVEL3_EXCLUSIONS = new ExclusionsMap(){
        {
            this.put(DisplacementEquation.Displacement_2C2H6_7O2_4CO2_6H2O.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_4CO2_6H2O_2C2H6_7O2.class);
                    this.add(DisplacementEquation.Displacement_2C2H2_5O2_4CO2_2H2O.class);
                }
            });
            this.put(DisplacementEquation.Displacement_4CO2_6H2O_2C2H6_7O2.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_2C2H6_7O2_4CO2_6H2O.class);
                    this.add(DisplacementEquation.Displacement_4CO2_2H2O_2C2H2_5O2.class);
                }
            });
            this.put(DisplacementEquation.Displacement_2C2H2_5O2_4CO2_2H2O.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_4CO2_2H2O_2C2H2_5O2.class);
                    this.add(DisplacementEquation.Displacement_2C2H6_7O2_4CO2_6H2O.class);
                }
            });
            this.put(DisplacementEquation.Displacement_4CO2_2H2O_2C2H2_5O2.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_2C2H2_5O2_4CO2_2H2O.class);
                    this.add(DisplacementEquation.Displacement_4CO2_6H2O_2C2H6_7O2.class);
                }
            });
            this.put(DisplacementEquation.Displacement_C2H5OH_3O2_2CO2_3H2O.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_2CO2_3H2O_C2H5OH_3O2.class);
                }
            });
            this.put(DisplacementEquation.Displacement_2CO2_3H2O_C2H5OH_3O2.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_C2H5OH_3O2_2CO2_3H2O.class);
                }
            });
            this.put(DisplacementEquation.Displacement_4NH3_3O2_2N2_6H2O.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_2N2_6H2O_4NH3_3O2.class);
                    this.add(DisplacementEquation.Displacement_4NH3_5O2_4NO_6H2O.class);
                    this.add(DisplacementEquation.Displacement_4NH3_7O2_4NO2_6H2O.class);
                    this.add(DisplacementEquation.Displacement_4NH3_6NO_5N2_6H2O.class);
                }
            });
            this.put(DisplacementEquation.Displacement_4NH3_5O2_4NO_6H2O.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_4NO_6H2O_4NH3_5O2.class);
                    this.add(DisplacementEquation.Displacement_4NH3_3O2_2N2_6H2O.class);
                    this.add(DisplacementEquation.Displacement_4NH3_7O2_4NO2_6H2O.class);
                    this.add(DisplacementEquation.Displacement_4NH3_6NO_5N2_6H2O.class);
                }
            });
            this.put(DisplacementEquation.Displacement_4NH3_7O2_4NO2_6H2O.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_4NO2_6H2O_4NH3_7O2.class);
                    this.add(DisplacementEquation.Displacement_4NH3_3O2_2N2_6H2O.class);
                    this.add(DisplacementEquation.Displacement_4NH3_5O2_4NO_6H2O.class);
                    this.add(DisplacementEquation.Displacement_4NH3_6NO_5N2_6H2O.class);
                }
            });
            this.put(DisplacementEquation.Displacement_4NH3_6NO_5N2_6H2O.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_5N2_6H2O_4NH3_6NO.class);
                    this.add(DisplacementEquation.Displacement_4NH3_3O2_2N2_6H2O.class);
                    this.add(DisplacementEquation.Displacement_4NH3_5O2_4NO_6H2O.class);
                    this.add(DisplacementEquation.Displacement_4NH3_7O2_4NO2_6H2O.class);
                }
            });
            this.put(DisplacementEquation.Displacement_2N2_6H2O_4NH3_3O2.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_4NH3_3O2_2N2_6H2O.class);
                    this.add(DisplacementEquation.Displacement_4NO_6H2O_4NH3_5O2.class);
                    this.add(DisplacementEquation.Displacement_4NO2_6H2O_4NH3_7O2.class);
                    this.add(DisplacementEquation.Displacement_5N2_6H2O_4NH3_6NO.class);
                }
            });
            this.put(DisplacementEquation.Displacement_4NO_6H2O_4NH3_5O2.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_4NH3_5O2_4NO_6H2O.class);
                    this.add(DisplacementEquation.Displacement_2N2_6H2O_4NH3_3O2.class);
                    this.add(DisplacementEquation.Displacement_4NO2_6H2O_4NH3_7O2.class);
                    this.add(DisplacementEquation.Displacement_5N2_6H2O_4NH3_6NO.class);
                }
            });
            this.put(DisplacementEquation.Displacement_4NO2_6H2O_4NH3_7O2.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_4NH3_7O2_4NO2_6H2O.class);
                    this.add(DisplacementEquation.Displacement_2N2_6H2O_4NH3_3O2.class);
                    this.add(DisplacementEquation.Displacement_4NO_6H2O_4NH3_5O2.class);
                    this.add(DisplacementEquation.Displacement_5N2_6H2O_4NH3_6NO.class);
                }
            });
            this.put(DisplacementEquation.Displacement_5N2_6H2O_4NH3_6NO.class, new EquationClassesList(){
                {
                    this.add(DisplacementEquation.Displacement_4NH3_6NO_5N2_6H2O.class);
                    this.add(DisplacementEquation.Displacement_2N2_6H2O_4NH3_3O2.class);
                    this.add(DisplacementEquation.Displacement_4NO_6H2O_4NH3_5O2.class);
                    this.add(DisplacementEquation.Displacement_4NO2_6H2O_4NH3_7O2.class);
                }
            });
        }
    };
    private static HashMap<Integer, IGameStrategy> STRATEGIES = new HashMap<Integer, IGameStrategy>(){
        {
            this.put(1, new RandomStrategy(LEVEL1_POOL, false));
            this.put(2, new RandomStrategy(LEVEL2_POOL, true));
            this.put(3, new RandomWithExclusionsStrategy(LEVEL3_POOL, LEVEL3_EXCLUSIONS, true));
        }
    };
    private static HashMap<Integer, IGameStrategy> DEV_STRATEGIES = new HashMap<Integer, IGameStrategy>(){
        {
            this.put(1, new EntirePoolStrategy(LEVEL1_POOL));
            this.put(2, new EntirePoolStrategy(LEVEL2_POOL));
            this.put(3, new EntirePoolStrategy(LEVEL3_POOL));
        }
    };
    private Property<Boolean> playAllEquationsProperty;

    public GameFactory(Property<Boolean> property) {
        this.playAllEquationsProperty = property;
    }

    public ArrayList<Equation> createEquations(int n, int n2) {
        if (!STRATEGIES.containsKey(n2)) {
            throw new IllegalArgumentException("unsupported level: " + n2);
        }
        IGameStrategy iGameStrategy = this.playAllEquationsProperty.get() != false ? DEV_STRATEGIES.get(n2) : STRATEGIES.get(n2);
        EquationClassesList equationClassesList = iGameStrategy.getEquationClasses(n);
        ArrayList<Equation> arrayList = new ArrayList<Equation>();
        for (Class clazz : equationClassesList) {
            arrayList.add(GameFactory.instantiateEquation(clazz));
        }
        return arrayList;
    }

    private static Equation instantiateEquation(Class<? extends Equation> clazz) {
        Equation equation = null;
        try {
            equation = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return equation;
    }

    private static class EntirePoolStrategy
    implements IGameStrategy {
        private final EquationClassesList pool;

        public EntirePoolStrategy(EquationClassesList equationClassesList) {
            this.pool = equationClassesList;
        }

        public EquationClassesList getEquationClasses(int n) {
            return new EquationClassesList(this.pool);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EquationClassesList
    extends ArrayList<Class<? extends Equation>> {
        public EquationClassesList() {
        }

        public EquationClassesList(EquationClassesList equationClassesList) {
            super(equationClassesList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExclusionsMap
    extends HashMap<Class<? extends Equation>, EquationClassesList> {
        private ExclusionsMap() {
        }
    }

    private static interface IGameStrategy {
        public EquationClassesList getEquationClasses(int var1);
    }

    private static class RandomStrategy
    extends RandomWithExclusionsStrategy {
        public RandomStrategy(EquationClassesList equationClassesList, boolean bl) {
            super(equationClassesList, new ExclusionsMap(), bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RandomWithExclusionsStrategy
    implements IGameStrategy {
        private final EquationClassesList pool;
        private final ExclusionsMap exclusions;
        private final boolean firstBigMolecule;

        public RandomWithExclusionsStrategy(EquationClassesList equationClassesList, ExclusionsMap exclusionsMap, boolean bl) {
            this.pool = equationClassesList;
            this.exclusions = exclusionsMap;
            this.firstBigMolecule = bl;
        }

        @Override
        public EquationClassesList getEquationClasses(int n) {
            EquationClassesList equationClassesList = new EquationClassesList(this.pool);
            EquationClassesList equationClassesList2 = new EquationClassesList();
            for (int i = 0; i < n; ++i) {
                int n2 = (int)(Math.random() * (double)equationClassesList.size());
                Class clazz = (Class)equationClassesList.get(n2);
                if (i == 0 && !this.firstBigMolecule && this.hasBigMolecule(clazz)) {
                    int n3;
                    int n4 = n3 = (int)(Math.random() * (double)equationClassesList.size());
                    boolean bl = false;
                    while (!bl) {
                        clazz = (Class)equationClassesList.get(n4);
                        if (!this.hasBigMolecule(clazz)) {
                            bl = true;
                            continue;
                        }
                        if (++n4 > equationClassesList.size() - 1) {
                            n4 = 0;
                        }
                        if (n4 != n3) continue;
                        bl = true;
                        System.err.println("ERROR: first equation contains big molecules because we ran out of equations");
                    }
                }
                equationClassesList2.add(clazz);
                equationClassesList.remove(clazz);
                EquationClassesList equationClassesList3 = (EquationClassesList)this.exclusions.get(clazz);
                if (equationClassesList3 != null) {
                    equationClassesList.removeAll(equationClassesList3);
                }
                if (i >= n - 1 || equationClassesList.size() != 0) continue;
                System.err.print("ERROR: GameFactory.RandomWithExclusionsStrategy.getEquationClasses ran out of equations, ");
                System.err.print("numberOfEquations=" + n);
                System.err.println(" equationClasses=" + equationClassesList2.toString());
                break;
            }
            assert (equationClassesList2.size() == n);
            assert (this.firstBigMolecule || !this.hasBigMolecule((Class)equationClassesList2.get(0)));
            return equationClassesList2;
        }

        private boolean hasBigMolecule(Class<? extends Equation> clazz) {
            return GameFactory.instantiateEquation(clazz).hasBigMolecule();
        }
    }
}

