/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.module.game;

import edu.colorado.phet.balancingchemicalequations.BCEGlobalProperties;
import edu.colorado.phet.balancingchemicalequations.BCEStrings;
import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.module.game.GameModel;
import edu.colorado.phet.balancingchemicalequations.view.BCECanvas;
import edu.colorado.phet.balancingchemicalequations.view.BoxesNode;
import edu.colorado.phet.balancingchemicalequations.view.DevAnswerNode;
import edu.colorado.phet.balancingchemicalequations.view.EquationNode;
import edu.colorado.phet.balancingchemicalequations.view.HorizontalAligner;
import edu.colorado.phet.balancingchemicalequations.view.game.BalancedNode;
import edu.colorado.phet.balancingchemicalequations.view.game.BalancedNotSimplifiedNode;
import edu.colorado.phet.balancingchemicalequations.view.game.GameRewardNode;
import edu.colorado.phet.balancingchemicalequations.view.game.NotBalancedTerseNode;
import edu.colorado.phet.balancingchemicalequations.view.game.NotBalancedVerboseNode;
import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.games.GameOverNode;
import edu.colorado.phet.common.games.GameScoreboardNode;
import edu.colorado.phet.common.games.GameSettingsPanel;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;

class GameCanvas
extends BCECanvas {
    private static final Dimension BOX_SIZE = new Dimension(475, 400);
    private static final Color BUTTONS_COLOR = Color.YELLOW;
    private static final PhetFont BUTTONS_FONT = new PhetFont(1, 30);
    private final GameModel model;
    private final BCEGlobalProperties globalProperties;
    private final GameAudioPlayer audioPlayer;
    private final GameOverNode.GameOverListener newGameButtonListener;
    private final HorizontalAligner aligner;
    private final PNode gameSettingsNode;
    private final PNode gamePlayParentNode;
    private GameOverNode gameOverNode;
    private final GameRewardNode gameRewardNode;
    private PNode popupNode;
    private final PText equationLabelNode;
    private final EquationNode equationNode;
    private final BoxesNode boxesNode;
    private final HTMLImageButtonNode checkButton;
    private final HTMLImageButtonNode tryAgainButton;
    private final HTMLImageButtonNode showAnswerButton;
    private final HTMLImageButtonNode nextButton;
    private final GameScoreboardNode scoreboardNode;
    private final ActionListener showWhyButtonListener;
    private final ActionListener hideWhyButtonListener;

    public GameCanvas(final GameModel gameModel, final BCEGlobalProperties bCEGlobalProperties) {
        super(bCEGlobalProperties.canvasColor);
        this.model = gameModel;
        this.globalProperties = bCEGlobalProperties;
        this.audioPlayer = new GameAudioPlayer((Boolean)gameModel.settings.soundEnabled.get());
        this.aligner = new HorizontalAligner(BOX_SIZE, 90.0);
        this.gameRewardNode = new GameRewardNode();
        VoidFunction0 voidFunction0 = new VoidFunction0(){

            public void apply() {
                gameModel.startGame();
            }
        };
        this.gameSettingsNode = new PSwing(new GameSettingsPanel(gameModel.settings, voidFunction0));
        this.gameSettingsNode.scale(1.5);
        this.gamePlayParentNode = new PhetPNode();
        this.equationLabelNode = new PText("?");
        this.equationLabelNode.setTextPaint(Color.BLACK);
        this.equationLabelNode.setFont(new PhetFont(20));
        this.equationNode = new EquationNode(gameModel.currentEquation, gameModel.getCoefficientsRange(), this.aligner);
        this.boxesNode = new BoxesNode(gameModel.currentEquation, gameModel.getCoefficientsRange(), this.aligner, bCEGlobalProperties.boxColor, bCEGlobalProperties.moleculesVisible);
        this.checkButton = new HTMLImageButtonNode(BCEStrings.CHECK, BUTTONS_FONT, BUTTONS_COLOR);
        this.checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameCanvas.this.playGuessAudio();
                gameModel.check();
            }
        });
        this.tryAgainButton = new HTMLImageButtonNode(BCEStrings.TRY_AGAIN, BUTTONS_FONT, BUTTONS_COLOR);
        this.tryAgainButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gameModel.tryAgain();
            }
        });
        this.showAnswerButton = new HTMLImageButtonNode(BCEStrings.SHOW_ANSWER, BUTTONS_FONT, BUTTONS_COLOR);
        this.showAnswerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gameModel.showAnswer();
            }
        });
        this.nextButton = new HTMLImageButtonNode(BCEStrings.NEXT, BUTTONS_FONT, BUTTONS_COLOR);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gameModel.next();
            }
        });
        this.scoreboardNode = new GameScoreboardNode(gameModel.settings.level.getMax(), gameModel.getPerfectScore(), new DecimalFormat("0"));
        this.scoreboardNode.setBackgroundWidth(this.boxesNode.getFullBoundsReference().getWidth());
        this.scoreboardNode.addGameScoreboardListener(new GameScoreboardNode.GameScoreboardListener(){

            public void newGamePressed() {
                gameModel.newGame();
            }
        });
        final DevAnswerNode devAnswerNode = new DevAnswerNode(gameModel.currentEquation);
        devAnswerNode.setVisible(bCEGlobalProperties.answersVisible.get());
        this.addWorldChild(this.gameRewardNode);
        this.addWorldChild(this.gameSettingsNode);
        this.addWorldChild(this.gamePlayParentNode);
        this.gamePlayParentNode.addChild(this.equationLabelNode);
        this.gamePlayParentNode.addChild(this.equationNode);
        this.gamePlayParentNode.addChild(this.boxesNode);
        this.gamePlayParentNode.addChild(this.checkButton);
        this.gamePlayParentNode.addChild(this.tryAgainButton);
        this.gamePlayParentNode.addChild(this.showAnswerButton);
        this.gamePlayParentNode.addChild(this.nextButton);
        this.gamePlayParentNode.addChild(this.scoreboardNode);
        this.gamePlayParentNode.addChild(devAnswerNode);
        this.equationLabelNode.setOffset(0.0, 0.0);
        double d = this.equationLabelNode.getFullBoundsReference().getMaxY() + 25.0;
        this.equationNode.setOffset(0.0, d);
        d = this.equationNode.getFullBoundsReference().getMaxY() + 25.0;
        this.boxesNode.setOffset(0.0, d);
        double d2 = this.boxesNode.getFullBoundsReference().getCenterX() - this.checkButton.getFullBoundsReference().getWidth() / 2.0;
        d = this.boxesNode.getFullBoundsReference().getMaxY() + 25.0;
        this.checkButton.setOffset(d2, d);
        d2 = this.boxesNode.getFullBoundsReference().getCenterX() - this.tryAgainButton.getFullBoundsReference().getWidth() / 2.0;
        this.tryAgainButton.setOffset(d2, d);
        d2 = this.boxesNode.getFullBoundsReference().getCenterX() - this.showAnswerButton.getFullBoundsReference().getWidth() / 2.0;
        this.showAnswerButton.setOffset(d2, d);
        d2 = this.boxesNode.getFullBoundsReference().getCenterX() - this.nextButton.getFullBoundsReference().getWidth() / 2.0;
        this.nextButton.setOffset(d2, d);
        d2 = 0.0;
        d = this.checkButton.getFullBoundsReference().getMaxY() + 25.0;
        this.scoreboardNode.setOffset(d2, d);
        d2 = 0.0;
        d = this.boxesNode.getFullBoundsReference().getMaxY() + 5.0;
        devAnswerNode.setOffset(d2, d);
        this.gamePlayParentNode.setOffset(0.0, 0.0);
        double d3 = this.gamePlayParentNode.getFullBoundsReference().getCenterX() - this.gameSettingsNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = this.gamePlayParentNode.getFullBoundsReference().getCenterY() - this.gameSettingsNode.getFullBoundsReference().getHeight() / 2.0;
        this.gameSettingsNode.setOffset(d3, d2);
        this.newGameButtonListener = new GameOverNode.GameOverListener(){

            public void newGamePressed() {
                gameModel.newGame();
            }
        };
        gameModel.state.addObserver(new SimpleObserver(){

            public void update() {
                GameCanvas.this.handleGameStateChange(gameModel.state.get());
            }
        });
        gameModel.currentEquation.addObserver(new SimpleObserver(){

            public void update() {
                GameCanvas.this.updateEquationLabel();
            }
        });
        gameModel.settings.level.addObserver(new SimpleObserver(){

            public void update() {
                GameCanvas.this.scoreboardNode.setLevel((Integer)gameModel.settings.level.get());
            }
        });
        gameModel.settings.timerEnabled.addObserver(new SimpleObserver(){

            public void update() {
                GameCanvas.this.scoreboardNode.setTimerVisible((Boolean)gameModel.settings.timerEnabled.get());
            }
        });
        gameModel.settings.soundEnabled.addObserver(new SimpleObserver(){

            public void update() {
                GameCanvas.this.audioPlayer.setEnabled((Boolean)gameModel.settings.soundEnabled.get());
            }
        });
        gameModel.points.addObserver(new SimpleObserver(){

            public void update() {
                GameCanvas.this.scoreboardNode.setScore(gameModel.points.get().intValue());
            }
        });
        gameModel.timer.time.addObserver(new SimpleObserver(){

            public void update() {
                GameCanvas.this.scoreboardNode.setTime(gameModel.timer.time.get());
            }
        });
        bCEGlobalProperties.answersVisible.addObserver(new SimpleObserver(){

            public void update() {
                devAnswerNode.setVisible(bCEGlobalProperties.answersVisible.get());
            }
        });
        this.showWhyButtonListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameCanvas.this.swapPopups(new NotBalancedVerboseNode(gameModel.currentEquation.get(), bCEGlobalProperties, GameCanvas.this.hideWhyButtonListener, gameModel.getBalancedRepresentation(), GameCanvas.this.aligner));
            }
        };
        this.hideWhyButtonListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameCanvas.this.swapPopups(new NotBalancedTerseNode(bCEGlobalProperties, GameCanvas.this.showWhyButtonListener));
            }
        };
    }

    public GameRewardNode getRewardNode() {
        return this.gameRewardNode;
    }

    private void updateEquationLabel() {
        int n = this.model.getCurrentEquationIndex() + 1;
        int n2 = this.model.getNumberOfEquations();
        String string = MessageFormat.format(BCEStrings.EQUATION_0_OF_1, n, n2);
        this.equationLabelNode.setText(string);
    }

    private void handleGameStateChange(GameModel.GameState gameState) {
        if (gameState == GameModel.GameState.START_GAME) {
            this.initStartGame();
        } else if (gameState == GameModel.GameState.CHECK) {
            this.initCheck();
        } else if (gameState == GameModel.GameState.TRY_AGAIN) {
            this.initTryAgain();
        } else if (gameState == GameModel.GameState.SHOW_ANSWER) {
            this.initShowAnswer();
        } else if (gameState == GameModel.GameState.NEXT) {
            this.initNext();
        } else if (gameState == GameModel.GameState.NEW_GAME) {
            this.initNewGame();
        } else {
            throw new UnsupportedOperationException("unsupported GameState: " + (Object)((Object)gameState));
        }
    }

    public void initStartGame() {
        this.setGameRewardVisible(false);
        this.setTopLevelNodeVisible(this.gameSettingsNode);
    }

    public void initCheck() {
        this.setTopLevelNodeVisible(this.gamePlayParentNode);
        this.setButtonNodeVisible(this.checkButton);
        this.setPopupVisible(false);
        this.equationNode.setEditable(true);
        this.setBalancedHighlightEnabled(false);
    }

    public void initTryAgain() {
        this.setTopLevelNodeVisible(this.gamePlayParentNode);
        this.setButtonNodeVisible(this.tryAgainButton);
        this.setPopupVisible(true);
        this.equationNode.setEditable(false);
        this.setBalancedHighlightEnabled(false);
    }

    public void initShowAnswer() {
        this.setTopLevelNodeVisible(this.gamePlayParentNode);
        this.setButtonNodeVisible(this.showAnswerButton);
        this.setPopupVisible(true);
        this.equationNode.setEditable(false);
        this.setBalancedHighlightEnabled(false);
    }

    public void initNext() {
        this.setTopLevelNodeVisible(this.gamePlayParentNode);
        this.setButtonNodeVisible(this.nextButton);
        this.setPopupVisible(this.model.currentEquation.get().isBalancedAndSimplified());
        this.equationNode.setEditable(false);
        this.model.currentEquation.get().balance();
        this.setBalancedHighlightEnabled(true);
    }

    public void initNewGame() {
        this.setPopupVisible(false);
        this.setGameRewardVisible(true);
        this.playGameOverAudio();
        this.updateGameOverNode();
        this.setTopLevelNodeVisible(this.gameOverNode);
    }

    private void setGameRewardVisible(boolean bl) {
        if (bl) {
            this.gameRewardNode.setLevel((Integer)this.model.settings.level.get(), this.model.isPerfectScore());
        }
        this.gameRewardNode.setVisible(bl);
    }

    private void setTopLevelNodeVisible(PNode pNode) {
        this.gameSettingsNode.setVisible(false);
        this.gamePlayParentNode.setVisible(false);
        if (this.gameOverNode != null) {
            this.gameOverNode.setVisible(false);
        }
        pNode.setVisible(true);
    }

    private void setButtonNodeVisible(HTMLImageButtonNode hTMLImageButtonNode) {
        this.checkButton.setVisible(false);
        this.tryAgainButton.setVisible(false);
        this.showAnswerButton.setVisible(false);
        this.nextButton.setVisible(false);
        hTMLImageButtonNode.setVisible(true);
    }

    private void setBalancedHighlightEnabled(boolean bl) {
        this.equationNode.setBalancedHighlightEnabled(bl);
        this.boxesNode.setBalancedHighlightEnabled(bl);
    }

    private void setPopupVisible(boolean bl) {
        if (this.popupNode != null) {
            this.gamePlayParentNode.removeChild(this.popupNode);
            this.popupNode = null;
        }
        if (bl) {
            Equation equation = this.model.currentEquation.get();
            this.popupNode = equation.isBalancedAndSimplified() ? new BalancedNode(this.model.getCurrentPoints(), this.globalProperties) : (equation.isBalanced() ? new BalancedNotSimplifiedNode(this.globalProperties) : new NotBalancedTerseNode(this.globalProperties, this.showWhyButtonListener));
            PNodeLayoutUtils.alignInside(this.popupNode, this.boxesNode, 0, 0);
            if (this.popupNode.getFullBoundsReference().getMaxY() >= this.checkButton.getFullBoundsReference().getMinY()) {
                PNodeLayoutUtils.alignInside(this.popupNode, this.boxesNode, 3, 0);
            }
            this.gamePlayParentNode.addChild(this.popupNode);
        }
    }

    private void swapPopups(PNode pNode) {
        PNode pNode2 = this.popupNode;
        this.gamePlayParentNode.removeChild(this.popupNode);
        this.popupNode = pNode;
        double d = pNode2.getFullBoundsReference().getCenterX() - this.popupNode.getFullBoundsReference().getWidth() / 2.0;
        double d2 = pNode2.getFullBoundsReference().getMinY();
        this.popupNode.setOffset(d, d2);
        if (this.popupNode.getFullBoundsReference().getMaxY() > this.tryAgainButton.getFullBoundsReference().getMinY()) {
            d2 = this.tryAgainButton.getFullBoundsReference().getMinY() - this.popupNode.getFullBoundsReference().getHeight() - 5.0;
            this.popupNode.setOffset(d, d2);
        }
        this.gamePlayParentNode.addChild(this.popupNode);
    }

    private void playGuessAudio() {
        if (this.model.currentEquation.get().isBalancedAndSimplified()) {
            this.audioPlayer.correctAnswer();
        } else {
            this.audioPlayer.wrongAnswer();
        }
    }

    private void playGameOverAudio() {
        if (this.model.points.get() == 0) {
            this.audioPlayer.gameOverZeroScore();
        } else if (this.model.isPerfectScore()) {
            this.audioPlayer.gameOverPerfectScore();
        } else {
            this.audioPlayer.gameOverImperfectScore();
        }
    }

    private void updateGameOverNode() {
        if (this.gameOverNode != null) {
            this.removeWorldChild(this.gameOverNode);
            this.gameOverNode.removeGameOverListener(this.newGameButtonListener);
            this.gameOverNode = null;
        }
        int n = (Integer)this.model.settings.level.get();
        this.gameOverNode = new GameOverNode(n, this.model.points.get().intValue(), this.model.getPerfectScore(), new DecimalFormat("0"), this.model.timer.time.get(), this.model.getBestTime(n), this.model.isNewBestTime(), (Boolean)this.model.settings.timerEnabled.get());
        this.gameOverNode.scale(1.5);
        this.addWorldChild(this.gameOverNode);
        this.gameOverNode.addGameOverListener(this.newGameButtonListener);
        this.centerNode(this.gameOverNode);
    }

    protected void updateLayout() {
        super.updateLayout();
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() > 0.0 && dimension2D.getHeight() > 0.0) {
            PBounds pBounds = new PBounds(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight());
            this.gameRewardNode.setBounds(pBounds);
            this.centerNode(this.gameSettingsNode);
            this.centerNode(this.gameOverNode);
            this.centerNode(this.gamePlayParentNode);
        }
    }
}

