/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.model;

import edu.colorado.phet.balancingchemicalequations.model.AtomCount;
import edu.colorado.phet.balancingchemicalequations.model.EquationTerm;
import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Equation {
    public final EquationTerm[] reactants;
    public final EquationTerm[] products;
    public final Property<Boolean> balancedProperty;
    public final Property<Boolean> balancedAndSimplifiedProperty;

    public Equation(EquationTerm[] equationTermArray, EquationTerm[] equationTermArray2) {
        if (!(equationTermArray.length > 1 && equationTermArray2.length > 0 || equationTermArray.length > 0 && equationTermArray2.length > 1)) {
            throw new IllegalArgumentException("equation requires at least 2 reactants and 1 product, or 1 reactant and 2 products");
        }
        this.reactants = equationTermArray;
        this.products = equationTermArray2;
        this.balancedProperty = new Property<Boolean>(false);
        this.balancedAndSimplifiedProperty = new Property<Boolean>(false);
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                Equation.this.updateBalancedProperties();
            }
        };
        for (EquationTerm equationTerm : equationTermArray) {
            equationTerm.getUserCoefficientProperty().addObserver(simpleObserver);
        }
        for (EquationTerm equationTerm : equationTermArray2) {
            equationTerm.getUserCoefficientProperty().addObserver(simpleObserver);
        }
    }

    public void reset() {
        for (EquationTerm equationTerm : this.reactants) {
            equationTerm.reset();
        }
        for (EquationTerm equationTerm : this.products) {
            equationTerm.reset();
        }
    }

    private void updateBalancedProperties() {
        int n = this.reactants[0].getUserCoefficient() / this.reactants[0].getBalancedCoefficient();
        boolean bl = n > 0;
        for (EquationTerm equationTerm : this.reactants) {
            bl = bl && equationTerm.getUserCoefficient() == n * equationTerm.getBalancedCoefficient();
        }
        for (EquationTerm equationTerm : this.products) {
            bl = bl && equationTerm.getUserCoefficient() == n * equationTerm.getBalancedCoefficient();
        }
        this.balancedAndSimplifiedProperty.set(bl && n == 1);
        this.balancedProperty.set(bl);
    }

    public String getName() {
        return Equation.createName(this.reactants, this.products);
    }

    public EquationTerm[] getReactants() {
        return this.reactants;
    }

    public EquationTerm[] getProducts() {
        return this.products;
    }

    public boolean isBalanced() {
        return this.balancedProperty.get();
    }

    public Property<Boolean> getBalancedProperty() {
        return this.balancedProperty;
    }

    public boolean isBalancedAndSimplified() {
        return this.balancedAndSimplifiedProperty.get();
    }

    public void balance() {
        for (EquationTerm equationTerm : this.reactants) {
            equationTerm.setUserCoefficient(equationTerm.getBalancedCoefficient());
        }
        for (EquationTerm equationTerm : this.products) {
            equationTerm.setUserCoefficient(equationTerm.getBalancedCoefficient());
        }
    }

    public ArrayList<AtomCount> getAtomCounts() {
        ArrayList<AtomCount> arrayList = new ArrayList<AtomCount>();
        Equation.setAtomCounts(arrayList, this.reactants, true);
        Equation.setAtomCounts(arrayList, this.products, false);
        return arrayList;
    }

    private static void setAtomCounts(ArrayList<AtomCount> arrayList, EquationTerm[] equationTermArray, boolean bl) {
        for (EquationTerm equationTerm : equationTermArray) {
            for (Atom atom : equationTerm.getMolecule().getAtoms()) {
                boolean bl2 = false;
                for (AtomCount atomCount : arrayList) {
                    if (!atomCount.getElement().equals(atom.getElement())) continue;
                    if (bl) {
                        atomCount.setReactantsCount(atomCount.getReactantsCount() + equationTerm.getUserCoefficient());
                    } else {
                        atomCount.setProductsCount(atomCount.getProductsCount() + equationTerm.getUserCoefficient());
                    }
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                if (bl) {
                    arrayList.add(new AtomCount(atom.getElement(), equationTerm.getUserCoefficient(), 0));
                    continue;
                }
                arrayList.add(new AtomCount(atom.getElement(), 0, equationTerm.getUserCoefficient()));
            }
        }
    }

    public void addCoefficientsObserver(SimpleObserver simpleObserver) {
        for (EquationTerm equationTerm : this.reactants) {
            equationTerm.getUserCoefficientProperty().addObserver(simpleObserver);
        }
        for (EquationTerm equationTerm : this.products) {
            equationTerm.getUserCoefficientProperty().addObserver(simpleObserver);
        }
    }

    public void removeCoefficientsObserver(SimpleObserver simpleObserver) {
        for (EquationTerm equationTerm : this.reactants) {
            equationTerm.getUserCoefficientProperty().removeObserver(simpleObserver);
        }
        for (EquationTerm equationTerm : this.products) {
            equationTerm.getUserCoefficientProperty().removeObserver(simpleObserver);
        }
    }

    public boolean hasBigMolecule() {
        for (EquationTerm equationTerm : this.reactants) {
            if (!equationTerm.getMolecule().isBig()) continue;
            return true;
        }
        for (EquationTerm equationTerm : this.products) {
            if (!equationTerm.getMolecule().isBig()) continue;
            return true;
        }
        return false;
    }

    private static String createName(EquationTerm[] equationTermArray, EquationTerm[] equationTermArray2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < equationTermArray.length; ++n) {
            stringBuffer.append(equationTermArray[n].getBalancedCoefficient());
            stringBuffer.append(" ");
            stringBuffer.append(equationTermArray[n].getMolecule().getSymbol());
            if (n >= equationTermArray.length - 1) continue;
            stringBuffer.append(" + ");
        }
        stringBuffer.append(" -> ");
        for (n = 0; n < equationTermArray2.length; ++n) {
            stringBuffer.append(equationTermArray2[n].getBalancedCoefficient());
            stringBuffer.append(" ");
            stringBuffer.append(equationTermArray2[n].getMolecule().getSymbol());
            if (n >= equationTermArray2.length - 1) continue;
            stringBuffer.append(" + ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getName();
    }
}

