/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.model;

import edu.colorado.phet.balancingchemicalequations.BCEStrings;
import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.model.EquationTerm;
import edu.colorado.phet.balancingchemicalequations.model.Molecule;

public class DisplacementEquation
extends Equation {
    private DisplacementEquation(int n, Molecule molecule, int n2, Molecule molecule2, int n3, Molecule molecule3, int n4, Molecule molecule4) {
        super(new EquationTerm[]{new EquationTerm(n, molecule), new EquationTerm(n2, molecule2)}, new EquationTerm[]{new EquationTerm(n3, molecule3), new EquationTerm(n4, molecule4)});
    }

    public static class Displacement_2C2H2_5O2_4CO2_2H2O
    extends DisplacementEquation {
        public Displacement_2C2H2_5O2_4CO2_2H2O() {
            super(2, new Molecule.C2H2(), 5, new Molecule.O2(), 4, new Molecule.CO2(), 2, new Molecule.H2O());
        }
    }

    public static class Displacement_2C2H6_7O2_4CO2_6H2O
    extends DisplacementEquation {
        public Displacement_2C2H6_7O2_4CO2_6H2O() {
            super(2, new Molecule.C2H6(), 7, new Molecule.O2(), 4, new Molecule.CO2(), 6, new Molecule.H2O());
        }
    }

    public static class Displacement_2CO2_3H2O_C2H5OH_3O2
    extends DisplacementEquation {
        public Displacement_2CO2_3H2O_C2H5OH_3O2() {
            super(2, new Molecule.CO2(), 3, new Molecule.H2O(), 1, new Molecule.C2H5OH(), 3, new Molecule.O2());
        }
    }

    public static class Displacement_2C_2H2O_CH4_CO2
    extends DisplacementEquation {
        public Displacement_2C_2H2O_CH4_CO2() {
            super(2, new Molecule.CMolecule(), 2, new Molecule.H2O(), 1, new Molecule.CH4(), 1, new Molecule.CO2());
        }
    }

    public static class Displacement_2F2_H2O_OF2_2HF
    extends DisplacementEquation {
        public Displacement_2F2_H2O_OF2_2HF() {
            super(2, new Molecule.F2(), 1, new Molecule.H2O(), 1, new Molecule.OF2(), 2, new Molecule.HF());
        }
    }

    public static class Displacement_2N2_6H2O_4NH3_3O2
    extends DisplacementEquation {
        public Displacement_2N2_6H2O_4NH3_3O2() {
            super(2, new Molecule.N2(), 6, new Molecule.H2O(), 4, new Molecule.NH3(), 3, new Molecule.O2());
        }
    }

    public static class Displacement_4CO2_2H2O_2C2H2_5O2
    extends DisplacementEquation {
        public Displacement_4CO2_2H2O_2C2H2_5O2() {
            super(4, new Molecule.CO2(), 2, new Molecule.H2O(), 2, new Molecule.C2H2(), 5, new Molecule.O2());
        }
    }

    public static class Displacement_4CO2_6H2O_2C2H6_7O2
    extends DisplacementEquation {
        public Displacement_4CO2_6H2O_2C2H6_7O2() {
            super(4, new Molecule.CO2(), 6, new Molecule.H2O(), 2, new Molecule.C2H6(), 7, new Molecule.O2());
        }
    }

    public static class Displacement_4NH3_3O2_2N2_6H2O
    extends DisplacementEquation {
        public Displacement_4NH3_3O2_2N2_6H2O() {
            super(4, new Molecule.NH3(), 3, new Molecule.O2(), 2, new Molecule.N2(), 6, new Molecule.H2O());
        }
    }

    public static class Displacement_4NH3_5O2_4NO_6H2O
    extends DisplacementEquation {
        public Displacement_4NH3_5O2_4NO_6H2O() {
            super(4, new Molecule.NH3(), 5, new Molecule.O2(), 4, new Molecule.NO(), 6, new Molecule.H2O());
        }
    }

    public static class Displacement_4NH3_6NO_5N2_6H2O
    extends DisplacementEquation {
        public Displacement_4NH3_6NO_5N2_6H2O() {
            super(4, new Molecule.NH3(), 6, new Molecule.NO(), 5, new Molecule.N2(), 6, new Molecule.H2O());
        }
    }

    public static class Displacement_4NH3_7O2_4NO2_6H2O
    extends DisplacementEquation {
        public Displacement_4NH3_7O2_4NO2_6H2O() {
            super(4, new Molecule.NH3(), 7, new Molecule.O2(), 4, new Molecule.NO2(), 6, new Molecule.H2O());
        }
    }

    public static class Displacement_4NO2_6H2O_4NH3_7O2
    extends DisplacementEquation {
        public Displacement_4NO2_6H2O_4NH3_7O2() {
            super(4, new Molecule.NO2(), 6, new Molecule.H2O(), 4, new Molecule.NH3(), 7, new Molecule.O2());
        }
    }

    public static class Displacement_4NO_6H2O_4NH3_5O2
    extends DisplacementEquation {
        public Displacement_4NO_6H2O_4NH3_5O2() {
            super(4, new Molecule.NO(), 6, new Molecule.H2O(), 4, new Molecule.NH3(), 5, new Molecule.O2());
        }
    }

    public static class Displacement_5N2_6H2O_4NH3_6NO
    extends DisplacementEquation {
        public Displacement_5N2_6H2O_4NH3_6NO() {
            super(5, new Molecule.N2(), 6, new Molecule.H2O(), 4, new Molecule.NH3(), 6, new Molecule.NO());
        }
    }

    public static class Displacement_C2H4_3O2_2CO2_2H2O
    extends DisplacementEquation {
        public Displacement_C2H4_3O2_2CO2_2H2O() {
            super(1, new Molecule.C2H4(), 3, new Molecule.O2(), 2, new Molecule.CO2(), 2, new Molecule.H2O());
        }
    }

    public static class Displacement_C2H5OH_3O2_2CO2_3H2O
    extends DisplacementEquation {
        public Displacement_C2H5OH_3O2_2CO2_3H2O() {
            super(1, new Molecule.C2H5OH(), 3, new Molecule.O2(), 2, new Molecule.CO2(), 3, new Molecule.H2O());
        }
    }

    public static class Displacement_C2H6_Cl2_C2H5Cl_HCl
    extends DisplacementEquation {
        public Displacement_C2H6_Cl2_C2H5Cl_HCl() {
            super(1, new Molecule.C2H6(), 1, new Molecule.Cl2(), 1, new Molecule.C2H5Cl(), 1, new Molecule.HCl());
        }
    }

    public static class Displacement_CH4_2O2_CO2_2H2O
    extends DisplacementEquation {
        public Displacement_CH4_2O2_CO2_2H2O() {
            super(1, new Molecule.CH4(), 2, new Molecule.O2(), 1, new Molecule.CO2(), 2, new Molecule.H2O());
        }

        public String getName() {
            return BCEStrings.COMBUST_METHANE;
        }
    }

    public static class Displacement_CH4_4S_CS2_2H2S
    extends DisplacementEquation {
        public Displacement_CH4_4S_CS2_2H2S() {
            super(1, new Molecule.CH4(), 4, new Molecule.SMolecule(), 1, new Molecule.CS2(), 2, new Molecule.H2S());
        }
    }

    public static class Displacement_CH4_H2O_3H2_CO
    extends DisplacementEquation {
        public Displacement_CH4_H2O_3H2_CO() {
            super(1, new Molecule.CH4(), 1, new Molecule.H2O(), 3, new Molecule.H2(), 1, new Molecule.CO());
        }
    }

    public static class Displacement_CS2_3O2_CO2_2SO2
    extends DisplacementEquation {
        public Displacement_CS2_3O2_CO2_2SO2() {
            super(1, new Molecule.CS2(), 3, new Molecule.O2(), 1, new Molecule.CO2(), 2, new Molecule.SO2());
        }
    }

    public static class Displacement_OF2_H2O_O2_2HF
    extends DisplacementEquation {
        public Displacement_OF2_H2O_O2_2HF() {
            super(1, new Molecule.OF2(), 1, new Molecule.H2O(), 1, new Molecule.O2(), 2, new Molecule.HF());
        }
    }

    public static class Displacement_SO2_2H2_S_2H2O
    extends DisplacementEquation {
        public Displacement_SO2_2H2_S_2H2O() {
            super(1, new Molecule.SO2(), 2, new Molecule.H2(), 1, new Molecule.SMolecule(), 2, new Molecule.H2O());
        }
    }

    public static class Displacement_SO2_3H2_H2S_2H2O
    extends DisplacementEquation {
        public Displacement_SO2_3H2_H2S_2H2O() {
            super(1, new Molecule.SO2(), 3, new Molecule.H2(), 1, new Molecule.H2S(), 2, new Molecule.H2O());
        }
    }
}

