/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.model;

import edu.colorado.phet.balancingchemicalequations.BCEStrings;
import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.model.EquationTerm;
import edu.colorado.phet.balancingchemicalequations.model.Molecule;

public abstract class DecompositionEquation
extends Equation {
    private DecompositionEquation(int n, Molecule molecule, int n2, Molecule molecule2, int n3, Molecule molecule3) {
        super(new EquationTerm[]{new EquationTerm(n, molecule)}, new EquationTerm[]{new EquationTerm(n2, molecule2), new EquationTerm(n3, molecule3)});
    }

    public static class Decomposition_2CO2_2CO_O2
    extends DecompositionEquation {
        public Decomposition_2CO2_2CO_O2() {
            super(2, new Molecule.CO2(), 2, new Molecule.CO(), 1, new Molecule.O2());
        }
    }

    public static class Decomposition_2CO_C_CO2
    extends DecompositionEquation {
        public Decomposition_2CO_C_CO2() {
            super(2, new Molecule.CO(), 1, new Molecule.CMolecule(), 1, new Molecule.CO2());
        }
    }

    public static class Decomposition_2H2O_2H2_O2
    extends DecompositionEquation {
        public Decomposition_2H2O_2H2_O2() {
            super(2, new Molecule.H2O(), 2, new Molecule.H2(), 1, new Molecule.O2());
        }

        public String getName() {
            return BCEStrings.SEPARATE_WATER;
        }
    }

    public static class Decomposition_2HCl_H2_Cl2
    extends DecompositionEquation {
        public Decomposition_2HCl_H2_Cl2() {
            super(2, new Molecule.HCl(), 1, new Molecule.H2(), 1, new Molecule.Cl2());
        }
    }

    public static class Decomposition_2NH3_N2_3H2
    extends DecompositionEquation {
        public Decomposition_2NH3_N2_3H2() {
            super(2, new Molecule.NH3(), 1, new Molecule.N2(), 3, new Molecule.H2());
        }
    }

    public static class Decomposition_2NO2_2NO_O2
    extends DecompositionEquation {
        public Decomposition_2NO2_2NO_O2() {
            super(2, new Molecule.NO2(), 2, new Molecule.NO(), 1, new Molecule.O2());
        }
    }

    public static class Decomposition_2NO_N2_O2
    extends DecompositionEquation {
        public Decomposition_2NO_N2_O2() {
            super(2, new Molecule.NO(), 1, new Molecule.N2(), 1, new Molecule.O2());
        }
    }

    public static class Decomposition_2SO3_2SO2_O2
    extends DecompositionEquation {
        public Decomposition_2SO3_2SO2_O2() {
            super(2, new Molecule.SO3(), 2, new Molecule.SO2(), 1, new Molecule.O2());
        }
    }

    public static class Decomposition_4PCl3_P4_6Cl2
    extends DecompositionEquation {
        public Decomposition_4PCl3_P4_6Cl2() {
            super(4, new Molecule.PCl3(), 1, new Molecule.P4(), 6, new Molecule.Cl2());
        }
    }

    public static class Decomposition_C2H6_C2H4_H2
    extends DecompositionEquation {
        public Decomposition_C2H6_C2H4_H2() {
            super(1, new Molecule.C2H6(), 1, new Molecule.C2H4(), 1, new Molecule.H2());
        }
    }

    public static class Decomposition_CH3OH_CO_2H2
    extends DecompositionEquation {
        public Decomposition_CH3OH_CO_2H2() {
            super(1, new Molecule.CH3OH(), 1, new Molecule.CO(), 2, new Molecule.H2());
        }
    }

    public static class Decomposition_PCl5_PCl3_Cl2
    extends DecompositionEquation {
        public Decomposition_PCl5_PCl3_Cl2() {
            super(1, new Molecule.PCl5(), 1, new Molecule.PCl3(), 1, new Molecule.Cl2());
        }
    }
}

