/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.developer;

import edu.colorado.phet.balancingchemicalequations.BCEConstants;
import edu.colorado.phet.balancingchemicalequations.model.Molecule;
import edu.colorado.phet.common.phetcommon.view.controls.ColorControl;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreviewMoleculesCanvas
extends PhetPCanvas {
    public PreviewMoleculesCanvas(Frame frame) {
        this(frame, BCEConstants.CANVAS_BACKGROUND, 8, 100, 100, 20, new Molecule[]{new Molecule.CMolecule(), new Molecule.C2H2(), new Molecule.C2H4(), new Molecule.C2H5Cl(), new Molecule.C2H5OH(), new Molecule.C2H6(), new Molecule.CH2O(), new Molecule.CH3OH(), new Molecule.CH4(), new Molecule.Cl2(), new Molecule.CO(), new Molecule.CO2(), new Molecule.CS2(), new Molecule.F2(), new Molecule.H2(), new Molecule.H2O(), new Molecule.H2S(), new Molecule.HCl(), new Molecule.HF(), new Molecule.N2(), new Molecule.N2O(), new Molecule.NH3(), new Molecule.NO(), new Molecule.NO2(), new Molecule.O2(), new Molecule.OF2(), new Molecule.P4(), new Molecule.PCl3(), new Molecule.PCl5(), new Molecule.PF3(), new Molecule.PH3(), new Molecule.SMolecule(), new Molecule.SO2(), new Molecule.SO3()});
    }

    public PreviewMoleculesCanvas(Frame frame, Color color, int n, int n2, int n3, int n4, Molecule[] moleculeArray) {
        int n5;
        this.setBackground(color);
        PNode pNode = new PNode();
        this.addWorldChild(pNode);
        for (Molecule molecule : moleculeArray) {
            pNode.addChild(new LabeledMoleculeNode(molecule));
        }
        PSwing pSwing = new PSwing(new CanvasColorControl(frame, this));
        this.addWorldChild(pSwing);
        for (n5 = 0; n5 < pNode.getChildrenCount(); ++n5) {
            PNode pNode2 = pNode.getChild(n5);
            double d = n4 + n5 % n * n2;
            double d2 = n4 + n5 / n * n3;
            pNode2.setOffset(d, d2);
        }
        pSwing.setOffset(n4, pNode.getFullBoundsReference().getMaxY() + 10.0);
        n5 = (int)pNode.getFullBoundsReference().getMaxX() + n4;
        int n6 = (int)pSwing.getFullBoundsReference().getMaxY() + n4;
        this.setPreferredSize(new Dimension(n5, n6));
    }

    private static class CanvasColorControl
    extends JPanel {
        public CanvasColorControl(Frame frame, final PCanvas pCanvas) {
            this.setBorder(new CompoundBorder(new LineBorder(Color.WHITE), new LineBorder(Color.BLACK)));
            final ColorControl colorControl = new ColorControl(frame, "background color:", pCanvas.getBackground());
            this.add(colorControl);
            SwingUtils.setBackgroundDeep(this, Color.WHITE);
            colorControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    pCanvas.setBackground(colorControl.getColor());
                }
            });
        }
    }

    private static class LabeledMoleculeNode
    extends PComposite {
        public LabeledMoleculeNode(Molecule molecule) {
            PImage pImage = new PImage(molecule.getImage());
            this.addChild(pImage);
            HTMLNode hTMLNode = new HTMLNode(molecule.getSymbol());
            hTMLNode.setHTMLColor(Color.BLACK);
            this.addChild(hTMLNode);
            double d = pImage.getFullBoundsReference().getCenterX() - hTMLNode.getFullBoundsReference().getWidth() / 2.0;
            double d2 = pImage.getFullBoundsReference().getMaxY() + 2.0;
            hTMLNode.setOffset(d, d2);
        }
    }
}

